import java.awt.*;
import java.awt.event.*;

public class RectangleTool implements Tool {
   
  protected DrawingCanvas canvas;
  protected Point startingMousePosition;
  protected Point currentMousePosition;
  protected Color saveColor;

  public RectangleTool(DrawingCanvas c) {
   canvas = c;
  }
  
  protected void drawRectangle(int x, int y, int width, int height) {
    int rectX = x;
    int rectY = y;
    int rectWidth = width;
    int rectHeight = height;
    if (width < 0) {
      rectX = x + width;
      rectWidth = -width;
    } 
    if (height < 0) {
      rectY = y + height;
      rectHeight = -height;
    }
    Graphics iBGraphics = canvas.getimageBufferGraphics();
    iBGraphics.drawRect(rectX, rectY, rectWidth, rectHeight);
      
    canvas.repaint();
  }

 public void mousePressed(MouseEvent e)  {
   /* Establish starting point for next drawing */
   startingMousePosition = e.getPoint();
   currentMousePosition = startingMousePosition;
   Graphics iBGraphics = canvas.getimageBufferGraphics();
   saveColor = iBGraphics.getColor( );
   iBGraphics.setXORMode(Color.lightGray);
   iBGraphics.setColor(Color.white);
   drawRectangle(startingMousePosition.x,
		 startingMousePosition.y, 1,1);
						
 }

 public void mouseDragged(MouseEvent e)  {
   Point newMousePosition = e.getPoint();
   drawRectangle(startingMousePosition.x, startingMousePosition.y,
         	currentMousePosition.x -startingMousePosition.x +1,
		currentMousePosition.y - startingMousePosition.y +1);
   drawRectangle(startingMousePosition.x,startingMousePosition.y,
                 newMousePosition.x -startingMousePosition.x + 1,
		 newMousePosition.y- startingMousePosition.y + 1);
   /* update current mouse coordinates */
   currentMousePosition = newMousePosition;
 }


  public void mouseReleased(MouseEvent e) { 
    Graphics iBGraphics = canvas.getimageBufferGraphics();
    drawRectangle(startingMousePosition.x, startingMousePosition.y,
		   currentMousePosition.x - startingMousePosition.x + 1,
         	   currentMousePosition.y - startingMousePosition.y + 1);
    iBGraphics.setPaintMode();
    iBGraphics.setColor(saveColor);
    drawRectangle(startingMousePosition.x, startingMousePosition.y,
                   e.getPoint().x -startingMousePosition.x +1,
		   e.getPoint().y - startingMousePosition.y +1);
		    
		   
  }
}
