import java.awt.*;
import java.awt.event.*;

public class OvalTool implements Tool {
   
  protected DrawingCanvas canvas;
  protected Point startingMousePosition;
  protected Point currentMousePosition;
  protected Color saveColor;

  public OvalTool(DrawingCanvas c) {
   canvas = c;
  }
  
  protected void drawOval(int x, int y, int width, int height) {
    int ovalX = x;
    int ovalY = y;
    int ovalWidth = width;
    int ovalHeight = height;
    if (width < 0) {
      ovalX = x + width;
      ovalWidth = -width;
    } 
    if (height < 0) {
      ovalY = y + height;
      ovalHeight = -height;
    }
    Graphics iBGraphics = canvas.getimageBufferGraphics();
    iBGraphics.drawOval(ovalX, ovalY, ovalWidth, ovalHeight);
      
    canvas.repaint();
  }


 public void mousePressed(MouseEvent e)  {
   /* Establish starting point for next drawing */
   startingMousePosition = e.getPoint();
   currentMousePosition = startingMousePosition;
   Graphics iBGraphics = canvas.getimageBufferGraphics();
   saveColor = iBGraphics.getColor( );
   iBGraphics.setXORMode(Color.lightGray);
   iBGraphics.setColor(Color.white);
   drawOval(startingMousePosition.x,
		 startingMousePosition.y, 1,1);
						
 }

 public void mouseDragged(MouseEvent e)  {
   Point newMousePosition = e.getPoint();
   drawOval(startingMousePosition.x, startingMousePosition.y,
         	currentMousePosition.x -startingMousePosition.x +1,
		currentMousePosition.y - startingMousePosition.y +1);
   drawOval(startingMousePosition.x,startingMousePosition.y,
                 newMousePosition.x -startingMousePosition.x + 1,
		 newMousePosition.y- startingMousePosition.y + 1);
   /* update current mouse coordinates */
   currentMousePosition = newMousePosition;
 }


  public void mouseReleased(MouseEvent e) { 
    Graphics iBGraphics = canvas.getimageBufferGraphics();
    drawOval(startingMousePosition.x, startingMousePosition.y,
		   currentMousePosition.x - startingMousePosition.x + 1,
         	   currentMousePosition.y - startingMousePosition.y + 1);
    iBGraphics.setPaintMode();
    iBGraphics.setColor(saveColor);
    drawOval(startingMousePosition.x, startingMousePosition.y,
                   e.getPoint().x -startingMousePosition.x +1,
		   e.getPoint().y - startingMousePosition.y +1);
		    
  }
}
